		<script type="text/javascript" src="/jscripts/addressbook.js"></script>
		<script type="text/javascript">
			$().ready(function() {
				window.address_field = "To";
				var oldSearchVal='';
				var delay = (function(){
						var timer = 0;
						return function(callback, ms){
							clearTimeout (timer);
							timer = setTimeout(callback, ms);
						};
				})();
				$('#address_search_input').focus(function(e1) {
					$('#cancel_button').keydown(function(e) { 
						var code = (e.keyCode ? e.keyCode : e.which);
						if(code == 9) { //tab keycode
							if(!e.shiftKey) {
								e.preventDefault();
								$('#address_search_input').focus();
							}
						}
					});
				});
				$('#address_search_input').keydown(function(e) { 
						var code = (e.keyCode ? e.keyCode : e.which);
						if(code == 9) { //tab keycode
							if(e.shiftKey) {
								e.preventDefault();
								$('#cancel_button').focus();
							}
						}
					});
				$('input[name="address_search_input"]').keyup(function(){
					if($('input[name="address_search_input"]').val() != oldSearchVal) {
						delay(function() {
							var search = $('input[name="address_search_input"]').val();
							$.getJSON('/addressbook/ajax_search/' + encodeURIComponent(search) + '/?<?PHP echo $this->security->get_csrf_token_name(); ?>=' + $('input[name="<?PHP echo $this->security->get_csrf_token_name(); ?>"]').val(), function(data) {
								processResult(data,search,'<?PHP echo $this->security->get_csrf_token_name(); ?>');
							});
							oldSearchVal=search;
						},1000);		
					}
				});
			});
		</script>
		<div id="address_book_wrapper">
			<?PHP  /*make sure csrf token is on the page for AJAX requests (GET as well as POST) */
				echo form_hidden($this->security->get_csrf_token_name(),$this->security->get_csrf_hash(),$this->security->get_csrf_token_name(),'token'); 
			?>
			<div id="content">
				<div id="search_panel">
					<div id="search-box">
						<label for="address_search_input" class="hidden_context">Address Book Search Input</label>
						<input type="text" name="address_search_input" id="address_search_input" /><button type="button" id="address_search_btn" onclick="search('<?PHP echo $this->security->get_csrf_token_name(); ?>');">Search</button>
					</div>
					<div id="result_info"></div>
					<div id="result_list">
						<?PHP
							if(isset($initial_json)) {
								$i = 0;
								foreach(json_decode($initial_json,true) as $entry) {
									if(isset($entry['name'])) {
										if(isset($entry["title"]) && isset($entry["departmentnumber"])) { echo "<br />" . $entry["title"] . ", " . $entry["departmentnumber"]; }
										else if(isset($entry["title"]) && !isset($entry["departmentnumber"]) && isset($entry["o"])) { echo "<br />" . $entry["title"] . ", " . $entry["o"]; }
										else if(isset($entry["title"])) { echo "<br />" . $entry["title"]; }
										else if(isset($entry["departmentnumber"])) { echo "<br />" . $entry["departmentnumber"]; }
										if(isset($entry["telephonenumber"]) && isset($entry["mobile"])) { echo "<br />" . $entry["telephonenumber"] . " " . $entry["mobile"]; }
										else if(isset($entry["telephonenumber"])) { echo "<br />" . $entry["telephonenumber"]; }
										else if(isset($entry["mobile"])) {  echo "<br />" . $entry["mobile"]; }
										echo "</a>";
									}
									else if(isset($entry['name'])) {
										echo '<a href="#" id="result' . $i  . '" class="result">' . $entry['name'];
										if(isset($entry['description'])) { echo "<br />" . $entry['description']; }
										echo '</a>';
									}
									$i++;
								}
								echo "<script type=\"text/javascript\">
											processResult(" . $initial_json . ",null,'".$this->security->get_csrf_token_name()."');
											$('#addressBookEntry').addClass('hidden_context');
									  </script>
									 ";
							}
						?>
					</div>
				</div>
				<div id="result_panel"></div>
			</div>
		</div>
